/*
 * Decompiled with CFR 0.152.
 */
package io.github.queerbric.pride;

import com.google.gson.Gson;
import io.github.queerbric.pride.PrideFlag;
import io.github.queerbric.pride.PrideFlags;
import java.io.File;
import java.io.FileReader;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.regex.Pattern;
import net.fabricmc.fabric.api.resource.SimpleResourceReloadListener;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_2960;
import net.minecraft.class_3298;
import net.minecraft.class_3300;
import net.minecraft.class_3695;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class PrideLoader
implements SimpleResourceReloadListener<List<PrideFlag>> {
    private static final class_2960 ID = new class_2960("pride", "flags");
    private static final Logger LOGGER = LogManager.getLogger((String)"pride");
    private static final Gson GSON = new Gson();
    private static final Pattern HEX_COLOR_PATTERN = Pattern.compile("^#[0-9a-fA-F]{6}$");

    public class_2960 getFabricId() {
        return ID;
    }

    public CompletableFuture<List<PrideFlag>> load(class_3300 manager, class_3695 profiler, Executor executor) {
        return CompletableFuture.supplyAsync(() -> PrideLoader.loadFlags(manager));
    }

    public CompletableFuture<Void> apply(List<PrideFlag> list, class_3300 manager, class_3695 profiler, Executor executor) {
        return CompletableFuture.runAsync(() -> PrideLoader.applyFlags(list));
    }

    public static List<PrideFlag> loadFlags(class_3300 manager) {
        ArrayList<PrideFlag> flags = new ArrayList<PrideFlag>();
        block22: for (Map.Entry entry : manager.method_14488("flags", path -> path.method_12832().endsWith(".json")).entrySet()) {
            class_2960 id = (class_2960)entry.getKey();
            String[] parts = id.method_12832().split("/");
            String name = parts[parts.length - 1];
            name = name.substring(0, name.length() - 5);
            try (InputStreamReader reader = new InputStreamReader(((class_3298)entry.getValue()).method_14482());){
                PrideFlag.Properties builder = (PrideFlag.Properties)GSON.fromJson((Reader)reader, PrideFlag.Properties.class);
                for (String color : builder.colors) {
                    if (HEX_COLOR_PATTERN.matcher(color).matches()) continue;
                    LOGGER.warn("[pride] Malformed flag data for flag " + name + ", " + color + " is not a valid color, must be a six-digit hex color like #FF00FF");
                    continue block22;
                }
                PrideFlag flag2 = new PrideFlag(name, builder);
                flags.add(flag2);
            }
            catch (Exception e) {
                LOGGER.warn("[pride] Malformed flag data for flag " + name, (Throwable)e);
            }
        }
        File prideFile = new File(FabricLoader.getInstance().getConfigDir().toFile(), "pride.json");
        if (prideFile.exists()) {
            try (FileReader reader = new FileReader(prideFile);){
                Config config = (Config)GSON.fromJson((Reader)reader, Config.class);
                if (config.flags != null) {
                    List<String> list = Arrays.asList(config.flags);
                    flags.removeIf(flag -> !list.contains(flag.getId()));
                }
            }
            catch (Exception e) {
                LOGGER.warn("[pride] Malformed flag data for pride.json config");
            }
        } else {
            class_2960 id = new class_2960("pride", "flags.json");
            Optional resource = manager.method_14486(id);
            if (resource.isPresent()) {
                try (InputStreamReader reader = new InputStreamReader(((class_3298)resource.get()).method_14482());){
                    Config config = (Config)GSON.fromJson((Reader)reader, Config.class);
                    if (config.flags != null) {
                        List<String> list = Arrays.asList(config.flags);
                        flags.removeIf(flag -> !list.contains(flag.getId()));
                    }
                }
                catch (Exception e) {
                    LOGGER.warn("[pride] Malformed flag data for flags.json", (Throwable)e);
                }
            }
        }
        return flags;
    }

    private static void applyFlags(List<PrideFlag> flags) {
        PrideFlags.setFlags(flags);
    }

    static class Config {
        String[] flags;

        Config() {
        }
    }
}

